// AT90USB/com_def.h
// Common defines for firmware and PC program
// S. Salewski, 23-MAR-2007

#ifndef _COM_DEF_H_
#define _COM_DEF_H_

#define MyUSB_VendorID 0x6667 // Atmel code
#define MyUSB_ProductID 0x6663 // arbitrary value
#define USB_VendorRequestCode (1<<6)

#define EP1_FIFO_Size 16  // OUT, control 1
#define EP1_Num_Banks 1
#define EP1_Direction UsbEP_DirOut

#define EP2_FIFO_Size 16  // IN,  control 2
#define EP2_Num_Banks 1
#define EP2_Direction UsbEP_DirIn

#define EP3_FIFO_Size 32  // OUT,  data (bulk, double buffered)
#define EP3_Num_Banks 2
#define EP3_Direction UsbEP_DirOut

#define EP4_FIFO_Size 32  // IN,   data (bulk, double buffered)
#define EP4_Num_Banks 2
#define EP4_Direction UsbEP_DirIn

#endif
